<?php
/*--------------------------------------------------------------------
 OnGetProductWeightEvent.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Core\Event\EventDispatcher;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductWeightEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Weight;
use ProductDataInterface;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class OnGetProductWeightEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetProductWeightEvent implements OnGetProductWeightEventInterface
{
    /**
     * @var ProductId
     */
    protected $productId;
    
    /**
     * @var ModifierIdentifierCollectionInterface
     */
    protected $modifiers;
    
    /**
     * @var ProductDataInterface
     */
    protected $product;
    
    /**
     * @var EventDispatcher
     */
    protected $dispatcher;
    
    /**
     * @var Weight
     */
    protected $weight;


    /**
     * OnGetProductWeightEvent constructor.
     *
     * @param ProductId $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param ProductDataInterface $product
     * @param EventDispatcherInterface $dispatcher
     */
    public function __construct(
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        ProductDataInterface $product,
        EventDispatcherInterface $dispatcher
    )
    {
        $this->productId  = $productId;
        $this->modifiers  = $modifiers;
        $this->product    = $product;
        $this->dispatcher = $dispatcher;
    }
    
    
    /**
     * @inheritDoc
     */
    public function dispatcher(): EventDispatcher
    {
        return $this->dispatcher;
    }
    
    
    /**
     * @inheritDoc
     */
    public function productId(): ProductId
    {
        return $this->productId;
    }
    
    
    /**
     * @inheritDoc
     */
    public function modifiers(): ModifierIdentifierCollectionInterface
    {
        return $this->modifiers;
    }
    
    
    /**
     * @inheritDoc
     */
    public function product(): ProductDataInterface
    {
        return $this->product;
    }
    
    
    /**
     * @inheritDoc
     */
    public function weight(): Weight
    {
        return $this->weight;
    }
    
    
    /**
     * @inheritDoc
     */
    public function setWeight(Weight $weight): void
    {
        $this->weight = $weight;
    }
}